﻿###########################################
## Programme écrit par Prénom Nom Classe ##
###########################################

import pygame,sys
from pygame.locals import *
import random, pickle, socket
speudo=input("Entrez votre speudo : ")
pygame.init()
pygame.font.init()
fenetre_jeu=pygame.display.set_mode((897,560))    	# Taille fenêtre du jeu en pixels
pygame.display.set_caption('Le duel')          	# titre de la fenêtre

###############################
## Déclaration des variables ##
###############################

max_missiles=3
score_serveur=0
score_client=0
missiles_serveur=[]
missiles_client=[]
Gauche = False
Droite = False
Haut = False
Bas = False
Texty = pygame.font.Font('SUPERPOI_R.TTF', 10)
Obj_texte = Texty.render('le duel', 0, (255,128,0))
texte_sore_client= Texty.render(str(score_client), 0, (255,255,255))
texte_score_serveur= Texty.render(str(score_serveur), 0, (255,255,255))
clock = pygame.time.Clock()
img_serveur = pygame.image.load('vaisseau.png')
img_aliens=pygame.image.load('invader1.png')
img_fond=pygame.image.load('galaxie.jpg')
rectangle_serveur = pygame.Rect(20,500,31,32)
rectangle_client = pygame.Rect(750,50,31,32)


#####################################
##           Fonctions             ##
#####################################

def detecte_touches(role,Gauche,Droite,Haut,Bas):
    """Paramètres:
        - role (str) "s" si serveur "c" si client
        - Gauche, Droite, Haut et Bas (booleen)

    retourne Gauche, Droite, Haut et Bas (booleen)

    Cette fonction permet de détecter les touches enfoncées ou relâchées
    de quitter le jeu ou de permettre le déplacement du vaisseau"""

    for event in pygame.event.get():
        if event.type==QUIT:		# Traite l'évènement fermer la fenêtre avec la souris
                pygame.quit()
                sys.exit()
        if event.type== KEYDOWN:	# Traiter les évènements du clavier
            if event.key==K_ESCAPE:
                pygame.quit()
                sys.exit()
            if event.key==K_RIGHT:
                Droite = True
            if event.key==K_UP:
                Haut = True
            if event.key==K_DOWN:
                Bas = True
            if event.key==K_LEFT:
                Gauche = True
            if event.key==K_SPACE and role=='s':
                if len(missiles_serveur)<max_missiles:
                    missiles_serveur.append(pygame.Rect(rectangle_serveur.left+12,rectangle_serveur.top,6,16))
            if event.key==K_SPACE and role=='c':
                if len(missiles_client)<max_missiles:
                    missiles_client.append(pygame.Rect(rectangle_client.left+12,rectangle_client.bottom,6,16))

        if event.type== KEYUP:
            if event.key==K_RIGHT:
                Droite = False
            if event.key==K_LEFT:
                Gauche = False
            if event.key==K_DOWN:
                Bas = False
            if event.key==K_UP:
                Haut = False
    return Gauche,Droite,Haut,Bas

def deplace_missiles():
    """ Paramètre : aucun
    retourne : rien
    Cette fonction permet de changer les coordonnées des missiles contenu dans la liste missiles"""
    for missile in missiles_serveur:				# pour chaque missiles existant
        missile.top=missile.top-10			# soustraire 10 à la coordonnée du point haut
        pygame.draw.rect(fenetre_jeu,0xFF0000,missile)	# dessinner un rectangle de couleur rouge
        if missile.top==50:				# si le missiles arrive en haut de l'écran
            missiles_serveur.remove(missile)			# supprimer le missiles de la liste



def detecte_collision(score_serveur,texte_score_serveur,speudo_serveur):
    """Paramètres :
        - score_serveur : int
        - texte_score_serveur : str
        - speudo_serveur : str

    retourne:
        - score_serveur : int
        - texte_score_serveur :str

    Cette fonction détecte une collision entre un missile et le client
    puis supprime le missile de la liste"""

    for missile in missiles_serveur:
            if missile.colliderect(rectangle_client):
                missiles_serveur.remove(missile)
                score_serveur+=1
                texte_score_serveur= Texty.render(speudo_serveur + " : " + str(score_serveur), 0, (255,255,255))
    return score_serveur,texte_score_serveur

def deplace_missiles_client():

    """Paramètre : aucun

        retourne : rien

    Cette fonction permet de changer les coordonnées des missiles contenu dans la liste missiles"""

    for missile in missiles_client:				# pour chaque missiles existant
        missile.top=missile.top+10			# soustraire 10 à la coordonnée du point haut
        pygame.draw.rect(fenetre_jeu,0x00FF00,missile)	# dessinner un rectangle de couleur rouge
        if missile.top>=500:				# si le missiles arrive en haut de l'écran
            missiles_client.remove(missile)			# supprimer le missiles de la liste


def detecte_collision_vaisseau(score_client,texte_sore_client,speudo_client):
    """Paramètres :
        - score_client : int
        - texte_sore_client : str
        - speudo_client : str

    retourne:
        - score_client : int
        - texte_sore_client :str

    Cette fonction détecte une collision entre un missile du client et le serveur
        puis supprime le missile la liste"""
    for missile in missiles_client:
        if rectangle_serveur.colliderect(missile):
            missiles_client.remove(missile)
            score_client+=1
            texte_sore_client= Texty.render(speudo_client + " : " + str(score_client), 0, (255,255,255))
    return score_client,texte_sore_client


def menu():

    """Paramètre : aucun

    retourne : str, 'c' pour client 's' pour serveur

    Cette fonction permet de choisir le rôle serveur ou client"""

    c=0

    fenetre_jeu.blit(img_fond,(0,0))
    while True:
        fenetre_jeu.blit(Texty.render('Space Invader - LE DUEL : ',0,(255,c,0)),(100,250))
        fenetre_jeu.blit(Texty.render('appuyer sur s : serveur c : client',0,(255,c,0)),(50,320))
        pygame.display.update()
        clock.tick(60)
        c+=15
        if c>=255: c=0
        for event in pygame.event.get():
            if event.type==QUIT:		# Traite l'évènement fermer la fenêtre avec la souris
                    pygame.quit()
                    sys.exit()
            if event.type== KEYDOWN:	# Traiter les évènements du clavier
                if event.key==K_ESCAPE:
                    pygame.quit()
                    sys.exit()

                # détections des touches s (serveur) et c (client)
                if event.key == K_s:
                    return 's'
                if event.key == K_c:
                    return 'c'


def connexion(role):

    """Paramètre :
        - role : str 'c' pour client 's' pour serveur

    retourne : objet client ou serveur

    Cette fonction permet de choisir le rôle serveur ou client"""

    import socket
    if role =='s':
        #Implanter le code de connexion du serveur



        # Fin du code de connexion du serveur

        return(client)

    else:
        #implanter le code de connexion du client



        # Fin du code de connexion du client

        return(serveur)


 ######################
 ## SCRIPT PRINCIPAL ##
 ######################


role=menu()

if role=='s':
    speudo_serveur=speudo
    client=connexion(role)
    pygame.display.set_caption('SpaceInvader SERVEUR')          	# titre de la fenêtre

else:
    speudo_client=speudo
    serveur=connexion(role)
    pygame.display.set_caption('SpaceInvader CLIENT')          	# titre de la fenêtre


while True:
    fenetre_jeu.blit(img_fond,(0,0))		# Placer l'image d'arrière plan
    fenetre_jeu.blit(Obj_texte,(50,20))			# Placer le texte
    fenetre_jeu.blit(img_serveur,rectangle_serveur)	# placer l'image
    fenetre_jeu.blit(img_aliens,rectangle_client)    # placer l'alien

    Gauche,Droite,Haut,Bas = detecte_touches(role,Gauche,Droite,Haut,Bas)


    # Déplacement du vaisseau du serveur ou du vaisseau du client





    # Fin du déplacement des vaisseaux


    score_serveur,texte_score_serveur = detecte_collision(score_serveur,texte_score_serveur,speudo_serveur)
    score_client,texte_sore_client = detecte_collision_vaisseau(score_client,texte_sore_client,speudo_client)
    fenetre_jeu.blit(texte_sore_client,(150,20))
    fenetre_jeu.blit(texte_score_serveur,(150,530))

    deplace_missiles()
    deplace_missiles_client()

    pygame.display.update()				# rafraichir l'affichage de la fenêtre jeu
    clock.tick(30)					# Vitesse du jeu : 30 FPS